##########################################################################################
### Analyses: relationships between sperm morphology, swimming velocity and stored ATP ###
##########################################################################################
	
	rm(list=ls())

### load raw data files: "Experimental males summary data.txt" and  
### "Microplate sample repeatability.txt"
	
	summarydata <- read.table(file.choose(),header=T) # note that missing values = NA
	wellrepeats <- read.table(file.choose(),header=T)

#########################################################################################
### Microplate sample repeatability #####################################################
#########################################################################################
	
### description of variables for file "Microplate sample repeatability.txt"

### Sample   		- an identifer for each males' samples 
### WellNumber		- an identifer for the repeat wells for each males' samples. Samples were run in 						triplicate.  
### BioUnit			- the bioluminescent value detected in the well.


### Analyses of well repeatability ######################################################
### repeatability of microplate samples measurements (methods from Lessels & Boag 1987)

	repeatwell <-read.table(file.choose(),header=T) 
	repeatwell$WellNumber <- as.factor(repeatwell$WellNumber)
	str(repeatwell)
	
	rep1 <- aov(repeatwell$BioUnit ~ repeatwell$Sample)
	summary(rep1)
	
#  					  Df Sum Sq    Mean Sq F value   Pr(>F)    
# repeatwell$Sample   38 537417734 14142572   7.411   5.64e-14 ***
# Residuals           78 148843557  1908251                     
# ---
# Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1 

# approx repeatability = 0.90   (n for this is 3)
# calculated repeatability = 
			# S2a = (MSa-MSw)/n   
			# S2a = (14142572-1908251)/2   = 6117160.5
			
			# S2 = MSw
			# s2a/(s2+s2a)
			# 6117160.5/(1908251+6117160.5)
			# 6117160.5/(8025411.5) = 0.76
			
#########################################################################################
### Relationships between sperm morphology, swimming velocity and stored ATP 
#########################################################################################

### description of variables for file "Experimental males summary data.txt"

### MaleID - unique identifier for each experimental male
### Line - the selection line identity of the male
### meanVSL - mean straight line velocity of all sampled sperm from a male 
### meanVAP - mean average path velocity of all sampled sperm from a male
### meanVCL - mean curvilinear velocity of all sampled sperm from a male
### meanPC1 - mean principle component 1 value of all sampled sperm from a male 
				(dervived from VAP, VSL & VCL)
### mean10VSL - mean straight line velocity of the fastest 10% of sampled sperm from a male
### mean10VAP - mean curvilinear velocity of the fastest 10% of sampled sperm from a male
### mean10VCL - mean curvilinear velocity of the fastest 10% of sampled sperm from a male
### mean10PC1 - mean principle component 1 value of the fastest 10% of sampled sperm from a male 					(dervived from VAP, VSL & VCL)
### meanhl - mean head length of all sampled sperm from a male
### meanml - mean midpiece length of all sampled sperm from a male
### meantail - mean tail length of all sampled sperm from a male
### meantl - mean total length of all sampled sperm from a male
### spermconc - sperm concentration (million) measured by Neubauer chamber
### averageATP - average ATP value from sampled sperm from a male (across the triplicate wells)
### averageATPnmols - average ATP value (nanomoles) from sampled sperm from a male (triplicate wells)
### standardisedATPnmolpermillionsperm - average ATP value (nanomoles) per million sperm from a male


### Analyses of sperm morphology, swimming velocity and stored ATP ##################################
#####################################################################################################

### Pearson's correlations between sperm components
	cor.test(summarydata$meanhl,summarydata$meantl)  	# r2 = 0.46
	cor.test(summarydata$meanml,summarydata$meantl)	    # r2 = -0.28
	cor.test(summarydata$meantail,summarydata$meantl)   # r2 = 0.88

### sperm morphology summary data across all males - included in Table S1	

### covariance function
	co.var <- function(x,na.rm=TRUE) 100*(sd(x,na.rm=na.rm)/mean(x,na.rm=na.rm))
	
	mean(summarydata$meanhl)   # 11.19um
	sd(summarydata$meanhl)     # 0.62
	range(summarydata$meanhl)  # 9.49 - 12.99
	co.var(summarydata$meanhl) # 5.55
	
	mean(summarydata$meanml)   # 30.47um
	sd(summarydata$meanml)     # 4.47
	range(summarydata$meanml)  # 16.11 - 39.80
	co.var(summarydata$meanml) # 14.67
	
	mean(summarydata$meantail)   # 24.72um
	sd(summarydata$meantail)     # 9.28
	range(summarydata$meantail)  # 9.55 - 46.74
	co.var(summarydata$meantail) # 37.55
	
	mean(summarydata$meantl)   # 66.38um
	sd(summarydata$meantl)     # 7.23
	range(summarydata$meantl)  # 49.57 - 79.76
	co.var(summarydata$meantl) # 10.90
	
	mean(summarydata$meanfl)   # 55.19um
	sd(summarydata$meanfl)     # 6.97
	range(summarydata$meanfl)  # 39.12 - 68.33
	co.var(summarydata$meanfl) # 12.63
	
### mean sperm swimming velocity summary data across all males - included in Table S2
	mean(summarydata$meanVSL)   # 39.08
	sd(summarydata$meanVSL)     # 15.83
	range(summarydata$meanVSL)  # 0.091 - 83.12 
	co.var(summarydata$meanVSL) # 40.51
	
	mean(summarydata$meanVCL)   # 53.53
	sd(summarydata$meanVCL)     # 16.91
	range(summarydata$meanVCL)  # 0.75 - 89.83 
	co.var(summarydata$meanVCL) # 31.58
	
	mean(summarydata$meanVAP)   # 42.89
	sd(summarydata$meanVAP)     # 15.76
	range(summarydata$meanVAP)  # 0.26 - 87.42 
	co.var(summarydata$meanVAP) # 36.75
	
### mean sperm swimming velocity summary data from fastest 10% of sperm across all males -  
### included in Table S2	
	mean(summarydata$mean10VSL)   # 69.67
	sd(summarydata$mean10VSL)     # 19.06
	range(summarydata$mean10VSL)  # 0.90 - 114.92 
	co.var(summarydata$mean10VSL) # 27.36
	
	mean(summarydata$mean10VCL)   # 83.81
	sd(summarydata$mean10VCL)     # 15.41
	range(summarydata$mean10VCL)  # 7.40 - 117.72 
	co.var(summarydata$mean10VCL) # 18.39
	
	mean(summarydata$mean10VAP)   # 73.18
	sd(summarydata$mean10VAP)     # 18.44
	range(summarydata$mean10VAP)  # 2.59 - 117.12 
	co.var(summarydata$mean10VAP) # 25.20

### Relationships between swimming velocity and sperm components
### (fastest 10% of sperm) across all males - included in Table S3.	
### calculate flagellum length, flagellum:head and midpiece:tail 
	summarydata$meanfl <- summarydata$meanml + summarydata$meantail
	summarydata$meanfhratio <- summarydata$meanfl/summarydata$meanhl
	summarydata$meanmtratio <- summarydata$meanml/summarydata$meantail

### head length 
	m1 <- lm(mean10PC1~meanhl, data=summarydata)
  summary(m1)
  
### midpiece length
	m1.2 <- lm(mean10PC1~meanml, data=summarydata)
  summary(m1.2)
  
### tail length	
	m1.3 <- lm(mean10PC1~meantail+I(meantail^2), data=summarydata)
	summary(m1.3)
	
### total length		
	m1.4 <- lm(mean10PC1~meantl+I(meantl^2), data=summarydata)
	summary(m1.4)
	
### flagellum: head 	
	m1.5 <- lm(mean10PC1~meanfhratio+I(meanfhratio^2), data=summarydata)
	summary(m1.5)
### midpiece: tail 
	m1.6 <- lm(mean10PC1~meanmtratio+I(meanmtratio^2), data=summarydata)
	summary(m1.6)
	
### Relationship between midpiece length and stored ATP	
### Log ATP 
				
	ATP <- log(summarydata$standardisedATPpermillionsperm)
	
	m2 <- lm(ATP ~ meanml, data=summarydata)
	summary(m2)
	
	Call:
	  lm(formula = ATP ~ meanml, data = summarydata)
	
	Residuals:
	  Min       1Q   Median       3Q      Max 
	-1.22598 -0.41876 -0.09896  0.37508  1.50833 
	
	Coefficients:
	  Estimate Std. Error t value Pr(>|t|)    
	(Intercept)  6.82475    0.75061   9.092 7.41e-11 ***
	  meanml      -0.08364    0.02542  -3.290  0.00225 ** 
	  ---
	  Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
	
	Residual standard error: 0.6334 on 36 degrees of freedom
	(144 observations deleted due to missingness)
	Multiple R-squared:  0.2312,	Adjusted R-squared:  0.2098 
	F-statistic: 10.83 on 1 and 36 DF,  p-value: 0.002246

###	Relationship between swimming velocity and stored ATP
	m3 <- lm(ATP ~ mean10PC1, data=summarydata)
	summary(m3)
	
	Call:
	  lm(formula = ATP ~ mean10PC1, data = summarydata)
	
	Residuals:
	  Min       1Q   Median       3Q      Max 
	-1.49382 -0.46071 -0.04876  0.28140  2.00703 
	
	Coefficients:
	  Estimate Std. Error t value Pr(>|t|)    
	(Intercept)  4.55918    0.43062  10.587 1.32e-12 ***
	  mean10PC1   -0.05537    0.12692  -0.436    0.665    
	---
	  Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
	
	Residual standard error: 0.7205 on 36 degrees of freedom
	(144 observations deleted due to missingness)
	Multiple R-squared:  0.005259,	Adjusted R-squared:  -0.02237 
	F-statistic: 0.1903 on 1 and 36 DF,  p-value: 0.6653

	
### Relationship between model for swimming velocity and ATP per unit midpiece length	
### length adjusted ATP content

	adjATP <- summarydata$standardisedATPpermillionsperm / summarydata$meanml
	adjATP <- log(adjATP)
	m4 <- lm(adjATP ~ mean10PC1, data = summarydata)	
	summary(m4)	  
	      	
	Call:
	  lm(formula = adjATP ~ mean10PC1, data = summarydata)
	
	Residuals:
	  Min       1Q   Median       3Q      Max 
	-1.74066 -0.50953 -0.02787  0.32824  2.22052 
	
	Coefficients:
	  Estimate Std. Error t value Pr(>|t|)  
	(Intercept)  1.23304    0.47756   2.582    0.014 *
	  mean10PC1   -0.06746    0.14076  -0.479    0.635  
	---
	  Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
	
	Residual standard error: 0.799 on 36 degrees of freedom
	(144 observations deleted due to missingness)
	Multiple R-squared:  0.00634,	Adjusted R-squared:  -0.02126 
	F-statistic: 0.2297 on 1 and 36 DF,  p-value: 0.6346			

### References
 	Lessels CM & Boag PT (1987) Unrepeatable repeatabilities: a common mistake. Auk 104:116-121.			